﻿// Modified the out-of-the-box JavaScript from SharePoint that provides the Office 365 
// drop down menus.  

// Function to hide the drop down menu
function CustomSuiteBarMenu_Hide (menuDivID, popupOwnerID) {
    // Get the drop down menu
    var menuDiv = document.getElementById(menuDivID);

    // If the menu exists, hide it and move it off the page
    if (menuDiv)
    {
        menuDiv.style.display = "none";
        menuDiv.style.top = "-10000px";
		
        // Remove the "active" css class from the parent link
        var popupOwner = document.getElementById(popupOwnerID);        
        RemoveCssClassFromElement(popupOwner, "ms-core-suiteLink-active");
    }
};

// Function to get the location details for the parent link, the code is copied from the 
// SharePoint JS files
function CustomSuiteBarMenu_GetRectangle (elem) {
    var rWin = elem.getBoundingClientRect();
    var xOff = Boolean(window.pageXOffset) ? window.pageXOffset : document.documentElement.scrollLeft;
    var yOff = Boolean(window.pageYOffset) ? window.pageYOffset : document.documentElement.scrollTop;
    var rDoc = {};

    rDoc.left = rWin.left + xOff;
    rDoc.right = rWin.right + xOff;
    rDoc.top = rWin.top + yOff;
    rDoc.bottom = rWin.bottom + yOff;
    return rDoc;
};
		
// Function to display the drop down menu
function CustomSuiteBarMenu_ShowMenu(popupOwnerID, menuDivID, navBarID) {
    // Check the script (of the current language) direction
    var IsRtl = window.document.documentElement.getAttribute("dir") == "rtl";

    // Get the drop down menu
    var menuDiv = document.getElementById(menuDivID);

    // Get the parent link
    var popupOwner = document.getElementById(popupOwnerID);

    // Get the suite bar container
    var navBar = document.getElementById(navBarID);
	
    // Hide the menu if it is already displayed
    CustomSuiteBarMenu_Hide(menuDivID, popupOwnerID);
	
    // Add the "active" css class to the parent link
    AddCssClassToElement(popupOwner, "ms-core-suiteLink-active");
	
    // Get the location details of the parent link
    var currentMenuOwnerBoundingRect = CustomSuiteBarMenu_GetRectangle(popupOwner);

    // Get the location details of the suite bar container
    var navBarBoundingRect = CustomSuiteBarMenu_GetRectangle(navBar);

    // Set the drop down menu to display (unhide it)
    menuDiv.style.display = "inline-block";

    // Set the location of the drop down menu based on the script direction, 
    // suite bar location, and parent link location
    var menuLeft;
    var menuWidth = menuDiv.offsetWidth;
	
    if (IsRtl) {
        menuLeft = currentMenuOwnerBoundingRect.right - menuWidth;
    }
    else {
        menuLeft = currentMenuOwnerBoundingRect.left;
    }
	
    var winWidth = document.documentElement.clientWidth;
    var winLeft = Boolean(window.pageXOffset) ? window.pageXOffset : document.documentElement.scrollLeft;
    var winRight = winLeft + winWidth;

    if (menuLeft < winLeft) {
        menuLeft = winLeft;
    }
    else if (menuLeft + menuWidth > winRight) {
        menuLeft = winRight - menuWidth;
    }
    menuDiv.style.left = String(Math.max(winLeft, menuLeft)) + "px";
    menuDiv.style.top = String(navBarBoundingRect.bottom) + "px";
};